
-- 
-- Definition of  datadelay
-- 
--      Mon Dec 08 20:39:47 1997
-- 
-- 
-- 

library IEEE, EXEMPLAR; use IEEE.STD_LOGIC_1164.all; use EXEMPLAR.EXEMPLAR_1164.all; 

entity datadelay is
   port (
      clk : IN std_logic ;
      din : IN std_logic ;
      en : IN std_logic ;
      dout : OUT std_logic) ;
end datadelay ;

architecture inference of datadelay is
   component FDSR1
      port (
         Q : OUT std_logic ;
         D : IN std_logic ;
         CP : IN std_logic) ;
   end component ;
   component MUX21S
      port (
         Z : OUT std_logic ;
         A : IN std_logic ;
         B : IN std_logic ;
         S : IN std_logic) ;
   end component ;
   signal q2, q1: std_logic ;

begin
   q2_XMPLR : FDSR1 port map ( Q=>q2, D=>q1, CP=>clk);
   q1_XMPLR : FDSR1 port map ( Q=>q1, D=>din, CP=>clk);
   dout_XMPLR_XMPLR : MUX21S port map ( Z=>dout, A=>q2, B=>q1, S=>en);
end inference ;

